/*  change video based on switch presses from Arduino
 *   --> uses a separate function to determine which video plays
 *
 *  original from Dan Shifman's processing Video Tutorial
 *   https://processing.org/tutorials/video
 *
 *  Setup circuit & Arduino - see documentation in the Arduino Sketch
 * 
 *  modified fred Wolflink @ MassArt 2/22/17
*/

import processing.serial.*; 
import processing.video.*;

Serial arduino;       // The serial port Arduino is connected to (over USB)
int buttonValue = 0;  // set initial value
int oldButtonValue;
int mySwitch;

Movie movie1;
Movie movie2;
Movie nowPlaying;

void setup() {
  size(320, 240);
  background(0);
  // List all the available serial ports
  printArray(Serial.list());

  // Open the port you are using at the rate you want:
  // update [0] below to match the actual port listed in the console
  // should be /dev/tty.usbmodem1411 on a Mac
  arduino = new Serial(this, Serial.list()[1], 9600);

  //movies
  movie1 = new Movie(this, "countdown.mov"); 
  movie2 = new Movie(this, "crashtest.mov");
  nowPlaying = movie1;  // need a movie to start with
}

void draw() {
  image(nowPlaying, 0, 0, width, height);
}

/*
  SerialEvent occurs whenever a new data comes in the
 hardware serial RX.  This routine is run between each
 time loop() runs, so using delay inside loop can delay
 response.  Multiple bytes of data may be available.
 */
void serialEvent(Serial arduino) {
  buttonValue = arduino.read();
  if ( (buttonValue != oldButtonValue) && (buttonValue != 0) ) {
    mySwitch = buttonValue;
    oldButtonValue = buttonValue;
    println(mySwitch);
    whichVideo();
  }
}

void whichVideo() {
  if (mySwitch == 1) {
    nowPlaying.stop();     // stop the current movie
    nowPlaying = movie1;   // switch movies
    nowPlaying.loop();     // set new movie to loop
  }
  if (mySwitch == 2) {
    nowPlaying.stop();
    nowPlaying = movie2;
    nowPlaying.loop();
  }
}

void movieEvent(Movie m) {
  m.read();
}